package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateIpSetResponse(ipSetId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse = {
    import CreateIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse
      .builder()
      .ipSetId(ipSetId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateIpSetResponse.ReadOnly =
    zio.aws.guardduty.model.CreateIpSetResponse.wrap(buildAwsValue())
}
object CreateIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateIpSetResponse =
      zio.aws.guardduty.model.CreateIpSetResponse(ipSetId)
    def ipSetId: String
    def getIpSetId: ZIO[Any, Nothing, String] = ZIO.succeed(ipSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse
  ) extends zio.aws.guardduty.model.CreateIpSetResponse.ReadOnly {
    override val ipSetId: String = impl.ipSetId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse
  ): zio.aws.guardduty.model.CreateIpSetResponse.ReadOnly = new Wrapper(impl)
}
