package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class CreateMembersRequest(
    detectorId: DetectorId,
    accountDetails: Iterable[zio.aws.guardduty.model.AccountDetail]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateMembersRequest = {
    import CreateMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateMembersRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .accountDetails(accountDetails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateMembersRequest.ReadOnly =
    zio.aws.guardduty.model.CreateMembersRequest.wrap(buildAwsValue())
}
object CreateMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateMembersRequest =
      zio.aws.guardduty.model.CreateMembersRequest(
        detectorId,
        accountDetails.map { item =>
          item.asEditable
        }
      )
    def detectorId: DetectorId
    def accountDetails: List[zio.aws.guardduty.model.AccountDetail.ReadOnly]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getAccountDetails: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.AccountDetail.ReadOnly
    ]] = ZIO.succeed(accountDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateMembersRequest
  ) extends zio.aws.guardduty.model.CreateMembersRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val accountDetails
        : List[zio.aws.guardduty.model.AccountDetail.ReadOnly] = impl
      .accountDetails()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.AccountDetail.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateMembersRequest
  ): zio.aws.guardduty.model.CreateMembersRequest.ReadOnly = new Wrapper(impl)
}
