package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateMembersResponse(
    unprocessedAccounts: Iterable[zio.aws.guardduty.model.UnprocessedAccount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateMembersResponse = {
    import CreateMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateMembersResponse
      .builder()
      .unprocessedAccounts(unprocessedAccounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateMembersResponse.ReadOnly =
    zio.aws.guardduty.model.CreateMembersResponse.wrap(buildAwsValue())
}
object CreateMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateMembersResponse =
      zio.aws.guardduty.model.CreateMembersResponse(unprocessedAccounts.map {
        item =>
          item.asEditable
      })
    def unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]
    def getUnprocessedAccounts: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.UnprocessedAccount.ReadOnly
    ]] = ZIO.succeed(unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateMembersResponse
  ) extends zio.aws.guardduty.model.CreateMembersResponse.ReadOnly {
    override val unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly] = impl
      .unprocessedAccounts()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.UnprocessedAccount.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateMembersResponse
  ): zio.aws.guardduty.model.CreateMembersResponse.ReadOnly = new Wrapper(impl)
}
