package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{ClientToken, DetectorId}
import scala.jdk.CollectionConverters.*
final case class CreatePublishingDestinationRequest(
    detectorId: DetectorId,
    destinationType: zio.aws.guardduty.model.DestinationType,
    destinationProperties: zio.aws.guardduty.model.DestinationProperties,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest = {
    import CreatePublishingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .destinationType(destinationType.unwrap)
      .destinationProperties(destinationProperties.buildAwsValue())
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.CreatePublishingDestinationRequest.ReadOnly =
    zio.aws.guardduty.model.CreatePublishingDestinationRequest
      .wrap(buildAwsValue())
}
object CreatePublishingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreatePublishingDestinationRequest =
      zio.aws.guardduty.model.CreatePublishingDestinationRequest(
        detectorId,
        destinationType,
        destinationProperties.asEditable,
        clientToken.map(value => value)
      )
    def detectorId: DetectorId
    def destinationType: zio.aws.guardduty.model.DestinationType
    def destinationProperties
        : zio.aws.guardduty.model.DestinationProperties.ReadOnly
    def clientToken: Optional[ClientToken]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getDestinationType
        : ZIO[Any, Nothing, zio.aws.guardduty.model.DestinationType] =
      ZIO.succeed(destinationType)
    def getDestinationProperties: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.DestinationProperties.ReadOnly
    ] = ZIO.succeed(destinationProperties)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest
  ) extends zio.aws.guardduty.model.CreatePublishingDestinationRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val destinationType: zio.aws.guardduty.model.DestinationType =
      zio.aws.guardduty.model.DestinationType.wrap(impl.destinationType())
    override val destinationProperties
        : zio.aws.guardduty.model.DestinationProperties.ReadOnly =
      zio.aws.guardduty.model.DestinationProperties
        .wrap(impl.destinationProperties())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.guardduty.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest
  ): zio.aws.guardduty.model.CreatePublishingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
