package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreatePublishingDestinationResponse(destinationId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse = {
    import CreatePublishingDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse
      .builder()
      .destinationId(destinationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.CreatePublishingDestinationResponse.ReadOnly =
    zio.aws.guardduty.model.CreatePublishingDestinationResponse
      .wrap(buildAwsValue())
}
object CreatePublishingDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.CreatePublishingDestinationResponse =
      zio.aws.guardduty.model.CreatePublishingDestinationResponse(destinationId)
    def destinationId: String
    def getDestinationId: ZIO[Any, Nothing, String] = ZIO.succeed(destinationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse
  ) extends zio.aws.guardduty.model.CreatePublishingDestinationResponse.ReadOnly {
    override val destinationId: String = impl.destinationId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse
  ): zio.aws.guardduty.model.CreatePublishingDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
