package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{FindingType, DetectorId}
import scala.jdk.CollectionConverters.*
final case class CreateSampleFindingsRequest(
    detectorId: DetectorId,
    findingTypes: Optional[Iterable[FindingType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest = {
    import CreateSampleFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .optionallyWith(
        findingTypes.map(value =>
          value.map { item =>
            FindingType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.findingTypes)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateSampleFindingsRequest.ReadOnly =
    zio.aws.guardduty.model.CreateSampleFindingsRequest.wrap(buildAwsValue())
}
object CreateSampleFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateSampleFindingsRequest =
      zio.aws.guardduty.model.CreateSampleFindingsRequest(
        detectorId,
        findingTypes.map(value => value)
      )
    def detectorId: DetectorId
    def findingTypes: Optional[List[FindingType]]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFindingTypes: ZIO[Any, AwsError, List[FindingType]] =
      AwsError.unwrapOptionField("findingTypes", findingTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest
  ) extends zio.aws.guardduty.model.CreateSampleFindingsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val findingTypes: Optional[List[FindingType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.primitives.FindingType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest
  ): zio.aws.guardduty.model.CreateSampleFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
