package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{
  DetectorId,
  TagValue,
  ClientToken,
  Name,
  Location,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateThreatIntelSetRequest(
    detectorId: DetectorId,
    name: Name,
    format: zio.aws.guardduty.model.ThreatIntelSetFormat,
    location: Location,
    activate: Boolean,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest = {
    import CreateThreatIntelSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .format(format.unwrap)
      .location(Location.unwrap(location): java.lang.String)
      .activate(activate: java.lang.Boolean)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.CreateThreatIntelSetRequest.ReadOnly =
    zio.aws.guardduty.model.CreateThreatIntelSetRequest.wrap(buildAwsValue())
}
object CreateThreatIntelSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateThreatIntelSetRequest =
      zio.aws.guardduty.model.CreateThreatIntelSetRequest(
        detectorId,
        name,
        format,
        location,
        activate,
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def detectorId: DetectorId
    def name: Name
    def format: zio.aws.guardduty.model.ThreatIntelSetFormat
    def location: Location
    def activate: Boolean
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.guardduty.model.ThreatIntelSetFormat] =
      ZIO.succeed(format)
    def getLocation: ZIO[Any, Nothing, Location] = ZIO.succeed(location)
    def getActivate: ZIO[Any, Nothing, Boolean] = ZIO.succeed(activate)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest
  ) extends zio.aws.guardduty.model.CreateThreatIntelSetRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val name: Name =
      zio.aws.guardduty.model.primitives.Name(impl.name())
    override val format: zio.aws.guardduty.model.ThreatIntelSetFormat =
      zio.aws.guardduty.model.ThreatIntelSetFormat.wrap(impl.format())
    override val location: Location =
      zio.aws.guardduty.model.primitives.Location(impl.location())
    override val activate: Boolean = impl.activate(): Boolean
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.guardduty.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.primitives
              .TagKey(key) -> zio.aws.guardduty.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest
  ): zio.aws.guardduty.model.CreateThreatIntelSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
