package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateThreatIntelSetResponse(threatIntelSetId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse = {
    import CreateThreatIntelSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse
      .builder()
      .threatIntelSetId(threatIntelSetId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.CreateThreatIntelSetResponse.ReadOnly =
    zio.aws.guardduty.model.CreateThreatIntelSetResponse.wrap(buildAwsValue())
}
object CreateThreatIntelSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.CreateThreatIntelSetResponse =
      zio.aws.guardduty.model.CreateThreatIntelSetResponse(threatIntelSetId)
    def threatIntelSetId: String
    def getThreatIntelSetId: ZIO[Any, Nothing, String] =
      ZIO.succeed(threatIntelSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse
  ) extends zio.aws.guardduty.model.CreateThreatIntelSetResponse.ReadOnly {
    override val threatIntelSetId: String = impl.threatIntelSetId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse
  ): zio.aws.guardduty.model.CreateThreatIntelSetResponse.ReadOnly =
    new Wrapper(impl)
}
