package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait CriterionKey {
  def unwrap: software.amazon.awssdk.services.guardduty.model.CriterionKey
}
object CriterionKey {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.CriterionKey
  ): zio.aws.guardduty.model.CriterionKey = value match {
    case software.amazon.awssdk.services.guardduty.model.CriterionKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.CriterionKey.EC2_INSTANCE_ARN =>
      val r = EC2_INSTANCE_ARN
      r
    case software.amazon.awssdk.services.guardduty.model.CriterionKey.SCAN_ID =>
      val r = SCAN_ID
      r
    case software.amazon.awssdk.services.guardduty.model.CriterionKey.ACCOUNT_ID =>
      val r = ACCOUNT_ID
      r
    case software.amazon.awssdk.services.guardduty.model.CriterionKey.GUARDDUTY_FINDING_ID =>
      val r = GUARDDUTY_FINDING_ID
      r
    case software.amazon.awssdk.services.guardduty.model.CriterionKey.SCAN_START_TIME =>
      val r = SCAN_START_TIME
      r
    case software.amazon.awssdk.services.guardduty.model.CriterionKey.SCAN_STATUS =>
      val r = SCAN_STATUS
      r
  }
  case object unknownToSdkVersion extends zio.aws.guardduty.model.CriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.CriterionKey =
      software.amazon.awssdk.services.guardduty.model.CriterionKey.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2_INSTANCE_ARN extends zio.aws.guardduty.model.CriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.CriterionKey =
      software.amazon.awssdk.services.guardduty.model.CriterionKey.EC2_INSTANCE_ARN
  }
  case object SCAN_ID extends zio.aws.guardduty.model.CriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.CriterionKey =
      software.amazon.awssdk.services.guardduty.model.CriterionKey.SCAN_ID
  }
  case object ACCOUNT_ID extends zio.aws.guardduty.model.CriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.CriterionKey =
      software.amazon.awssdk.services.guardduty.model.CriterionKey.ACCOUNT_ID
  }
  case object GUARDDUTY_FINDING_ID
      extends zio.aws.guardduty.model.CriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.CriterionKey =
      software.amazon.awssdk.services.guardduty.model.CriterionKey.GUARDDUTY_FINDING_ID
  }
  case object SCAN_START_TIME extends zio.aws.guardduty.model.CriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.CriterionKey =
      software.amazon.awssdk.services.guardduty.model.CriterionKey.SCAN_START_TIME
  }
  case object SCAN_STATUS extends zio.aws.guardduty.model.CriterionKey {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.CriterionKey =
      software.amazon.awssdk.services.guardduty.model.CriterionKey.SCAN_STATUS
  }
}
