package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DNSLogsConfigurationResult(
    status: zio.aws.guardduty.model.DataSourceStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DNSLogsConfigurationResult = {
    import DNSLogsConfigurationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DNSLogsConfigurationResult
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DNSLogsConfigurationResult.ReadOnly =
    zio.aws.guardduty.model.DNSLogsConfigurationResult.wrap(buildAwsValue())
}
object DNSLogsConfigurationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DNSLogsConfigurationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DNSLogsConfigurationResult =
      zio.aws.guardduty.model.DNSLogsConfigurationResult(status)
    def status: zio.aws.guardduty.model.DataSourceStatus
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.DataSourceStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DNSLogsConfigurationResult
  ) extends zio.aws.guardduty.model.DNSLogsConfigurationResult.ReadOnly {
    override val status: zio.aws.guardduty.model.DataSourceStatus =
      zio.aws.guardduty.model.DataSourceStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DNSLogsConfigurationResult
  ): zio.aws.guardduty.model.DNSLogsConfigurationResult.ReadOnly = new Wrapper(
    impl
  )
}
