package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait DataSource {
  def unwrap: software.amazon.awssdk.services.guardduty.model.DataSource
}
object DataSource {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.DataSource
  ): zio.aws.guardduty.model.DataSource = value match {
    case software.amazon.awssdk.services.guardduty.model.DataSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.DataSource.FLOW_LOGS =>
      val r = FLOW_LOGS
      r
    case software.amazon.awssdk.services.guardduty.model.DataSource.CLOUD_TRAIL =>
      val r = CLOUD_TRAIL
      r
    case software.amazon.awssdk.services.guardduty.model.DataSource.DNS_LOGS =>
      val r = DNS_LOGS
      r
    case software.amazon.awssdk.services.guardduty.model.DataSource.S3_LOGS =>
      val r = S3_LOGS
      r
    case software.amazon.awssdk.services.guardduty.model.DataSource.KUBERNETES_AUDIT_LOGS =>
      val r = KUBERNETES_AUDIT_LOGS
      r
    case software.amazon.awssdk.services.guardduty.model.DataSource.EC2_MALWARE_SCAN =>
      val r = EC2_MALWARE_SCAN
      r
  }
  case object unknownToSdkVersion extends zio.aws.guardduty.model.DataSource {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSource =
      software.amazon.awssdk.services.guardduty.model.DataSource.UNKNOWN_TO_SDK_VERSION
  }
  case object FLOW_LOGS extends zio.aws.guardduty.model.DataSource {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSource =
      software.amazon.awssdk.services.guardduty.model.DataSource.FLOW_LOGS
  }
  case object CLOUD_TRAIL extends zio.aws.guardduty.model.DataSource {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSource =
      software.amazon.awssdk.services.guardduty.model.DataSource.CLOUD_TRAIL
  }
  case object DNS_LOGS extends zio.aws.guardduty.model.DataSource {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSource =
      software.amazon.awssdk.services.guardduty.model.DataSource.DNS_LOGS
  }
  case object S3_LOGS extends zio.aws.guardduty.model.DataSource {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSource =
      software.amazon.awssdk.services.guardduty.model.DataSource.S3_LOGS
  }
  case object KUBERNETES_AUDIT_LOGS extends zio.aws.guardduty.model.DataSource {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSource =
      software.amazon.awssdk.services.guardduty.model.DataSource.KUBERNETES_AUDIT_LOGS
  }
  case object EC2_MALWARE_SCAN extends zio.aws.guardduty.model.DataSource {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSource =
      software.amazon.awssdk.services.guardduty.model.DataSource.EC2_MALWARE_SCAN
  }
}
