package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSourceConfigurations(
    s3Logs: Optional[zio.aws.guardduty.model.S3LogsConfiguration] =
      Optional.Absent,
    kubernetes: Optional[zio.aws.guardduty.model.KubernetesConfiguration] =
      Optional.Absent,
    malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DataSourceConfigurations = {
    import DataSourceConfigurations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DataSourceConfigurations
      .builder()
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .optionallyWith(kubernetes.map(value => value.buildAwsValue()))(
        _.kubernetes
      )
      .optionallyWith(malwareProtection.map(value => value.buildAwsValue()))(
        _.malwareProtection
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly =
    zio.aws.guardduty.model.DataSourceConfigurations.wrap(buildAwsValue())
}
object DataSourceConfigurations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DataSourceConfigurations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DataSourceConfigurations =
      zio.aws.guardduty.model.DataSourceConfigurations(
        s3Logs.map(value => value.asEditable),
        kubernetes.map(value => value.asEditable),
        malwareProtection.map(value => value.asEditable)
      )
    def s3Logs: Optional[zio.aws.guardduty.model.S3LogsConfiguration.ReadOnly]
    def kubernetes
        : Optional[zio.aws.guardduty.model.KubernetesConfiguration.ReadOnly]
    def malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionConfiguration.ReadOnly
    ]
    def getS3Logs: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.S3LogsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Logs", s3Logs)
    def getKubernetes: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.KubernetesConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("kubernetes", kubernetes)
    def getMalwareProtection: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.MalwareProtectionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("malwareProtection", malwareProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DataSourceConfigurations
  ) extends zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly {
    override val s3Logs
        : Optional[zio.aws.guardduty.model.S3LogsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Logs())
        .map(value => zio.aws.guardduty.model.S3LogsConfiguration.wrap(value))
    override val kubernetes
        : Optional[zio.aws.guardduty.model.KubernetesConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kubernetes())
        .map(value =>
          zio.aws.guardduty.model.KubernetesConfiguration.wrap(value)
        )
    override val malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.malwareProtection())
      .map(value =>
        zio.aws.guardduty.model.MalwareProtectionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DataSourceConfigurations
  ): zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly = new Wrapper(
    impl
  )
}
