package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSourceConfigurationsResult(
    cloudTrail: zio.aws.guardduty.model.CloudTrailConfigurationResult,
    dnsLogs: zio.aws.guardduty.model.DNSLogsConfigurationResult,
    flowLogs: zio.aws.guardduty.model.FlowLogsConfigurationResult,
    s3Logs: zio.aws.guardduty.model.S3LogsConfigurationResult,
    kubernetes: Optional[
      zio.aws.guardduty.model.KubernetesConfigurationResult
    ] = Optional.Absent,
    malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionConfigurationResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DataSourceConfigurationsResult = {
    import DataSourceConfigurationsResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DataSourceConfigurationsResult
      .builder()
      .cloudTrail(cloudTrail.buildAwsValue())
      .dnsLogs(dnsLogs.buildAwsValue())
      .flowLogs(flowLogs.buildAwsValue())
      .s3Logs(s3Logs.buildAwsValue())
      .optionallyWith(kubernetes.map(value => value.buildAwsValue()))(
        _.kubernetes
      )
      .optionallyWith(malwareProtection.map(value => value.buildAwsValue()))(
        _.malwareProtection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly =
    zio.aws.guardduty.model.DataSourceConfigurationsResult.wrap(buildAwsValue())
}
object DataSourceConfigurationsResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DataSourceConfigurationsResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DataSourceConfigurationsResult =
      zio.aws.guardduty.model.DataSourceConfigurationsResult(
        cloudTrail.asEditable,
        dnsLogs.asEditable,
        flowLogs.asEditable,
        s3Logs.asEditable,
        kubernetes.map(value => value.asEditable),
        malwareProtection.map(value => value.asEditable)
      )
    def cloudTrail
        : zio.aws.guardduty.model.CloudTrailConfigurationResult.ReadOnly
    def dnsLogs: zio.aws.guardduty.model.DNSLogsConfigurationResult.ReadOnly
    def flowLogs: zio.aws.guardduty.model.FlowLogsConfigurationResult.ReadOnly
    def s3Logs: zio.aws.guardduty.model.S3LogsConfigurationResult.ReadOnly
    def kubernetes: Optional[
      zio.aws.guardduty.model.KubernetesConfigurationResult.ReadOnly
    ]
    def malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionConfigurationResult.ReadOnly
    ]
    def getCloudTrail: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.CloudTrailConfigurationResult.ReadOnly
    ] = ZIO.succeed(cloudTrail)
    def getDnsLogs: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.DNSLogsConfigurationResult.ReadOnly
    ] = ZIO.succeed(dnsLogs)
    def getFlowLogs: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.FlowLogsConfigurationResult.ReadOnly
    ] = ZIO.succeed(flowLogs)
    def getS3Logs: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.S3LogsConfigurationResult.ReadOnly
    ] = ZIO.succeed(s3Logs)
    def getKubernetes: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.KubernetesConfigurationResult.ReadOnly
    ] = AwsError.unwrapOptionField("kubernetes", kubernetes)
    def getMalwareProtection: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.MalwareProtectionConfigurationResult.ReadOnly
    ] = AwsError.unwrapOptionField("malwareProtection", malwareProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DataSourceConfigurationsResult
  ) extends zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly {
    override val cloudTrail
        : zio.aws.guardduty.model.CloudTrailConfigurationResult.ReadOnly =
      zio.aws.guardduty.model.CloudTrailConfigurationResult
        .wrap(impl.cloudTrail())
    override val dnsLogs
        : zio.aws.guardduty.model.DNSLogsConfigurationResult.ReadOnly =
      zio.aws.guardduty.model.DNSLogsConfigurationResult.wrap(impl.dnsLogs())
    override val flowLogs
        : zio.aws.guardduty.model.FlowLogsConfigurationResult.ReadOnly =
      zio.aws.guardduty.model.FlowLogsConfigurationResult.wrap(impl.flowLogs())
    override val s3Logs
        : zio.aws.guardduty.model.S3LogsConfigurationResult.ReadOnly =
      zio.aws.guardduty.model.S3LogsConfigurationResult.wrap(impl.s3Logs())
    override val kubernetes: Optional[
      zio.aws.guardduty.model.KubernetesConfigurationResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kubernetes())
      .map(value =>
        zio.aws.guardduty.model.KubernetesConfigurationResult.wrap(value)
      )
    override val malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionConfigurationResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.malwareProtection())
      .map(value =>
        zio.aws.guardduty.model.MalwareProtectionConfigurationResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DataSourceConfigurationsResult
  ): zio.aws.guardduty.model.DataSourceConfigurationsResult.ReadOnly =
    new Wrapper(impl)
}
