package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class DataSourceFreeTrial(
    freeTrialDaysRemaining: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DataSourceFreeTrial = {
    import DataSourceFreeTrial.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DataSourceFreeTrial
      .builder()
      .optionallyWith(
        freeTrialDaysRemaining.map(value => value: java.lang.Integer)
      )(_.freeTrialDaysRemaining)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly =
    zio.aws.guardduty.model.DataSourceFreeTrial.wrap(buildAwsValue())
}
object DataSourceFreeTrial {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DataSourceFreeTrial
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DataSourceFreeTrial =
      zio.aws.guardduty.model
        .DataSourceFreeTrial(freeTrialDaysRemaining.map(value => value))
    def freeTrialDaysRemaining: Optional[Integer]
    def getFreeTrialDaysRemaining: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("freeTrialDaysRemaining", freeTrialDaysRemaining)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DataSourceFreeTrial
  ) extends zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly {
    override val freeTrialDaysRemaining: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.freeTrialDaysRemaining())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DataSourceFreeTrial
  ): zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly = new Wrapper(impl)
}
