package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait DataSourceStatus {
  def unwrap: software.amazon.awssdk.services.guardduty.model.DataSourceStatus
}
object DataSourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.DataSourceStatus
  ): zio.aws.guardduty.model.DataSourceStatus = value match {
    case software.amazon.awssdk.services.guardduty.model.DataSourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.DataSourceStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.guardduty.model.DataSourceStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.guardduty.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSourceStatus =
      software.amazon.awssdk.services.guardduty.model.DataSourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.guardduty.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSourceStatus =
      software.amazon.awssdk.services.guardduty.model.DataSourceStatus.ENABLED
  }
  case object DISABLED extends zio.aws.guardduty.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DataSourceStatus =
      software.amazon.awssdk.services.guardduty.model.DataSourceStatus.DISABLED
  }
}
