package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSourcesFreeTrial(
    cloudTrail: Optional[zio.aws.guardduty.model.DataSourceFreeTrial] =
      Optional.Absent,
    dnsLogs: Optional[zio.aws.guardduty.model.DataSourceFreeTrial] =
      Optional.Absent,
    flowLogs: Optional[zio.aws.guardduty.model.DataSourceFreeTrial] =
      Optional.Absent,
    s3Logs: Optional[zio.aws.guardduty.model.DataSourceFreeTrial] =
      Optional.Absent,
    kubernetes: Optional[
      zio.aws.guardduty.model.KubernetesDataSourceFreeTrial
    ] = Optional.Absent,
    malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DataSourcesFreeTrial = {
    import DataSourcesFreeTrial.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DataSourcesFreeTrial
      .builder()
      .optionallyWith(cloudTrail.map(value => value.buildAwsValue()))(
        _.cloudTrail
      )
      .optionallyWith(dnsLogs.map(value => value.buildAwsValue()))(_.dnsLogs)
      .optionallyWith(flowLogs.map(value => value.buildAwsValue()))(_.flowLogs)
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .optionallyWith(kubernetes.map(value => value.buildAwsValue()))(
        _.kubernetes
      )
      .optionallyWith(malwareProtection.map(value => value.buildAwsValue()))(
        _.malwareProtection
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DataSourcesFreeTrial.ReadOnly =
    zio.aws.guardduty.model.DataSourcesFreeTrial.wrap(buildAwsValue())
}
object DataSourcesFreeTrial {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DataSourcesFreeTrial
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DataSourcesFreeTrial =
      zio.aws.guardduty.model.DataSourcesFreeTrial(
        cloudTrail.map(value => value.asEditable),
        dnsLogs.map(value => value.asEditable),
        flowLogs.map(value => value.asEditable),
        s3Logs.map(value => value.asEditable),
        kubernetes.map(value => value.asEditable),
        malwareProtection.map(value => value.asEditable)
      )
    def cloudTrail
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly]
    def dnsLogs: Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly]
    def flowLogs: Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly]
    def s3Logs: Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly]
    def kubernetes: Optional[
      zio.aws.guardduty.model.KubernetesDataSourceFreeTrial.ReadOnly
    ]
    def malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial.ReadOnly
    ]
    def getCloudTrail: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField("cloudTrail", cloudTrail)
    def getDnsLogs: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField("dnsLogs", dnsLogs)
    def getFlowLogs: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField("flowLogs", flowLogs)
    def getS3Logs: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField("s3Logs", s3Logs)
    def getKubernetes: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.KubernetesDataSourceFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField("kubernetes", kubernetes)
    def getMalwareProtection: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial.ReadOnly
    ] = AwsError.unwrapOptionField("malwareProtection", malwareProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DataSourcesFreeTrial
  ) extends zio.aws.guardduty.model.DataSourcesFreeTrial.ReadOnly {
    override val cloudTrail
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudTrail())
        .map(value => zio.aws.guardduty.model.DataSourceFreeTrial.wrap(value))
    override val dnsLogs
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsLogs())
        .map(value => zio.aws.guardduty.model.DataSourceFreeTrial.wrap(value))
    override val flowLogs
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowLogs())
        .map(value => zio.aws.guardduty.model.DataSourceFreeTrial.wrap(value))
    override val s3Logs
        : Optional[zio.aws.guardduty.model.DataSourceFreeTrial.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Logs())
        .map(value => zio.aws.guardduty.model.DataSourceFreeTrial.wrap(value))
    override val kubernetes: Optional[
      zio.aws.guardduty.model.KubernetesDataSourceFreeTrial.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kubernetes())
      .map(value =>
        zio.aws.guardduty.model.KubernetesDataSourceFreeTrial.wrap(value)
      )
    override val malwareProtection: Optional[
      zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.malwareProtection())
      .map(value =>
        zio.aws.guardduty.model.MalwareProtectionDataSourceFreeTrial.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DataSourcesFreeTrial
  ): zio.aws.guardduty.model.DataSourcesFreeTrial.ReadOnly = new Wrapper(impl)
}
