package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class DeclineInvitationsRequest(accountIds: Iterable[AccountId]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest = {
    import DeclineInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest
      .builder()
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DeclineInvitationsRequest.ReadOnly =
    zio.aws.guardduty.model.DeclineInvitationsRequest.wrap(buildAwsValue())
}
object DeclineInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeclineInvitationsRequest =
      zio.aws.guardduty.model.DeclineInvitationsRequest(accountIds)
    def accountIds: List[AccountId]
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest
  ) extends zio.aws.guardduty.model.DeclineInvitationsRequest.ReadOnly {
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.AccountId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest
  ): zio.aws.guardduty.model.DeclineInvitationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
