package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeclineInvitationsResponse(
    unprocessedAccounts: Iterable[zio.aws.guardduty.model.UnprocessedAccount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse = {
    import DeclineInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse
      .builder()
      .unprocessedAccounts(unprocessedAccounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DeclineInvitationsResponse.ReadOnly =
    zio.aws.guardduty.model.DeclineInvitationsResponse.wrap(buildAwsValue())
}
object DeclineInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeclineInvitationsResponse =
      zio.aws.guardduty.model
        .DeclineInvitationsResponse(unprocessedAccounts.map { item =>
          item.asEditable
        })
    def unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]
    def getUnprocessedAccounts: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.UnprocessedAccount.ReadOnly
    ]] = ZIO.succeed(unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse
  ) extends zio.aws.guardduty.model.DeclineInvitationsResponse.ReadOnly {
    override val unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly] = impl
      .unprocessedAccounts()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.UnprocessedAccount.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse
  ): zio.aws.guardduty.model.DeclineInvitationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
