package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultServerSideEncryption(
    encryptionType: Optional[String] = Optional.Absent,
    kmsMasterKeyArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DefaultServerSideEncryption = {
    import DefaultServerSideEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DefaultServerSideEncryption
      .builder()
      .optionallyWith(encryptionType.map(value => value: java.lang.String))(
        _.encryptionType
      )
      .optionallyWith(kmsMasterKeyArn.map(value => value: java.lang.String))(
        _.kmsMasterKeyArn
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DefaultServerSideEncryption.ReadOnly =
    zio.aws.guardduty.model.DefaultServerSideEncryption.wrap(buildAwsValue())
}
object DefaultServerSideEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DefaultServerSideEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DefaultServerSideEncryption =
      zio.aws.guardduty.model.DefaultServerSideEncryption(
        encryptionType.map(value => value),
        kmsMasterKeyArn.map(value => value)
      )
    def encryptionType: Optional[String]
    def kmsMasterKeyArn: Optional[String]
    def getEncryptionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getKmsMasterKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsMasterKeyArn", kmsMasterKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DefaultServerSideEncryption
  ) extends zio.aws.guardduty.model.DefaultServerSideEncryption.ReadOnly {
    override val encryptionType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionType())
      .map(value => value: String)
    override val kmsMasterKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsMasterKeyArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DefaultServerSideEncryption
  ): zio.aws.guardduty.model.DefaultServerSideEncryption.ReadOnly = new Wrapper(
    impl
  )
}
