package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class DeleteDetectorRequest(detectorId: DetectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest = {
    import DeleteDetectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DeleteDetectorRequest.ReadOnly =
    zio.aws.guardduty.model.DeleteDetectorRequest.wrap(buildAwsValue())
}
object DeleteDetectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeleteDetectorRequest =
      zio.aws.guardduty.model.DeleteDetectorRequest(detectorId)
    def detectorId: DetectorId
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest
  ) extends zio.aws.guardduty.model.DeleteDetectorRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest
  ): zio.aws.guardduty.model.DeleteDetectorRequest.ReadOnly = new Wrapper(impl)
}
