package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class DeleteFilterRequest(
    detectorId: DetectorId,
    filterName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest = {
    import DeleteFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .filterName(filterName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DeleteFilterRequest.ReadOnly =
    zio.aws.guardduty.model.DeleteFilterRequest.wrap(buildAwsValue())
}
object DeleteFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeleteFilterRequest =
      zio.aws.guardduty.model.DeleteFilterRequest(detectorId, filterName)
    def detectorId: DetectorId
    def filterName: String
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFilterName: ZIO[Any, Nothing, String] = ZIO.succeed(filterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest
  ) extends zio.aws.guardduty.model.DeleteFilterRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val filterName: String = impl.filterName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest
  ): zio.aws.guardduty.model.DeleteFilterRequest.ReadOnly = new Wrapper(impl)
}
