package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class DeleteInvitationsRequest(accountIds: Iterable[AccountId]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest = {
    import DeleteInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest
      .builder()
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DeleteInvitationsRequest.ReadOnly =
    zio.aws.guardduty.model.DeleteInvitationsRequest.wrap(buildAwsValue())
}
object DeleteInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeleteInvitationsRequest =
      zio.aws.guardduty.model.DeleteInvitationsRequest(accountIds)
    def accountIds: List[AccountId]
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest
  ) extends zio.aws.guardduty.model.DeleteInvitationsRequest.ReadOnly {
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.AccountId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest
  ): zio.aws.guardduty.model.DeleteInvitationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
