package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class DeleteIpSetRequest(detectorId: DetectorId, ipSetId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest = {
    import DeleteIpSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .ipSetId(ipSetId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DeleteIpSetRequest.ReadOnly =
    zio.aws.guardduty.model.DeleteIpSetRequest.wrap(buildAwsValue())
}
object DeleteIpSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeleteIpSetRequest =
      zio.aws.guardduty.model.DeleteIpSetRequest(detectorId, ipSetId)
    def detectorId: DetectorId
    def ipSetId: String
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getIpSetId: ZIO[Any, Nothing, String] = ZIO.succeed(ipSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest
  ) extends zio.aws.guardduty.model.DeleteIpSetRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val ipSetId: String = impl.ipSetId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest
  ): zio.aws.guardduty.model.DeleteIpSetRequest.ReadOnly = new Wrapper(impl)
}
