package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.{AccountId, DetectorId}
import scala.jdk.CollectionConverters.*
final case class DeleteMembersRequest(
    detectorId: DetectorId,
    accountIds: Iterable[AccountId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest = {
    import DeleteMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DeleteMembersRequest.ReadOnly =
    zio.aws.guardduty.model.DeleteMembersRequest.wrap(buildAwsValue())
}
object DeleteMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeleteMembersRequest =
      zio.aws.guardduty.model.DeleteMembersRequest(detectorId, accountIds)
    def detectorId: DetectorId
    def accountIds: List[AccountId]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest
  ) extends zio.aws.guardduty.model.DeleteMembersRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.AccountId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest
  ): zio.aws.guardduty.model.DeleteMembersRequest.ReadOnly = new Wrapper(impl)
}
