package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class DeletePublishingDestinationRequest(
    detectorId: DetectorId,
    destinationId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest = {
    import DeletePublishingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .destinationId(destinationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.DeletePublishingDestinationRequest.ReadOnly =
    zio.aws.guardduty.model.DeletePublishingDestinationRequest
      .wrap(buildAwsValue())
}
object DeletePublishingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeletePublishingDestinationRequest =
      zio.aws.guardduty.model
        .DeletePublishingDestinationRequest(detectorId, destinationId)
    def detectorId: DetectorId
    def destinationId: String
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getDestinationId: ZIO[Any, Nothing, String] = ZIO.succeed(destinationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest
  ) extends zio.aws.guardduty.model.DeletePublishingDestinationRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val destinationId: String = impl.destinationId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest
  ): zio.aws.guardduty.model.DeletePublishingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
