package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class DeleteThreatIntelSetRequest(
    detectorId: DetectorId,
    threatIntelSetId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest = {
    import DeleteThreatIntelSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .threatIntelSetId(threatIntelSetId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DeleteThreatIntelSetRequest.ReadOnly =
    zio.aws.guardduty.model.DeleteThreatIntelSetRequest.wrap(buildAwsValue())
}
object DeleteThreatIntelSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DeleteThreatIntelSetRequest =
      zio.aws.guardduty.model
        .DeleteThreatIntelSetRequest(detectorId, threatIntelSetId)
    def detectorId: DetectorId
    def threatIntelSetId: String
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getThreatIntelSetId: ZIO[Any, Nothing, String] =
      ZIO.succeed(threatIntelSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest
  ) extends zio.aws.guardduty.model.DeleteThreatIntelSetRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val threatIntelSetId: String = impl.threatIntelSetId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest
  ): zio.aws.guardduty.model.DeleteThreatIntelSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
