package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.{IntegerValueWithMax, DetectorId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeMalwareScansRequest(
    detectorId: DetectorId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[IntegerValueWithMax] = Optional.Absent,
    filterCriteria: Optional[zio.aws.guardduty.model.FilterCriteria] =
      Optional.Absent,
    sortCriteria: Optional[zio.aws.guardduty.model.SortCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest = {
    import DescribeMalwareScansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => IntegerValueWithMax.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DescribeMalwareScansRequest.ReadOnly =
    zio.aws.guardduty.model.DescribeMalwareScansRequest.wrap(buildAwsValue())
}
object DescribeMalwareScansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DescribeMalwareScansRequest =
      zio.aws.guardduty.model.DescribeMalwareScansRequest(
        detectorId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        filterCriteria.map(value => value.asEditable),
        sortCriteria.map(value => value.asEditable)
      )
    def detectorId: DetectorId
    def nextToken: Optional[String]
    def maxResults: Optional[IntegerValueWithMax]
    def filterCriteria
        : Optional[zio.aws.guardduty.model.FilterCriteria.ReadOnly]
    def sortCriteria: Optional[zio.aws.guardduty.model.SortCriteria.ReadOnly]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, IntegerValueWithMax] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.guardduty.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.guardduty.model.SortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest
  ) extends zio.aws.guardduty.model.DescribeMalwareScansRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[IntegerValueWithMax] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.guardduty.model.primitives.IntegerValueWithMax(value)
        )
    override val filterCriteria
        : Optional[zio.aws.guardduty.model.FilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value => zio.aws.guardduty.model.FilterCriteria.wrap(value))
    override val sortCriteria
        : Optional[zio.aws.guardduty.model.SortCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortCriteria())
        .map(value => zio.aws.guardduty.model.SortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansRequest
  ): zio.aws.guardduty.model.DescribeMalwareScansRequest.ReadOnly = new Wrapper(
    impl
  )
}
