package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeMalwareScansResponse(
    scans: Iterable[zio.aws.guardduty.model.Scan],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse = {
    import DescribeMalwareScansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse
      .builder()
      .scans(scans.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.DescribeMalwareScansResponse.ReadOnly =
    zio.aws.guardduty.model.DescribeMalwareScansResponse.wrap(buildAwsValue())
}
object DescribeMalwareScansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DescribeMalwareScansResponse =
      zio.aws.guardduty.model.DescribeMalwareScansResponse(
        scans.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def scans: List[zio.aws.guardduty.model.Scan.ReadOnly]
    def nextToken: Optional[String]
    def getScans
        : ZIO[Any, Nothing, List[zio.aws.guardduty.model.Scan.ReadOnly]] =
      ZIO.succeed(scans)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse
  ) extends zio.aws.guardduty.model.DescribeMalwareScansResponse.ReadOnly {
    override val scans: List[zio.aws.guardduty.model.Scan.ReadOnly] = impl
      .scans()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.Scan.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DescribeMalwareScansResponse
  ): zio.aws.guardduty.model.DescribeMalwareScansResponse.ReadOnly =
    new Wrapper(impl)
}
