package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConfigurationResponse(
    autoEnable: Boolean,
    memberAccountLimitReached: Boolean,
    dataSources: Optional[
      zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse = {
    import DescribeOrganizationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse
      .builder()
      .autoEnable(autoEnable: java.lang.Boolean)
      .memberAccountLimitReached(memberAccountLimitReached: java.lang.Boolean)
      .optionallyWith(dataSources.map(value => value.buildAwsValue()))(
        _.dataSources
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse =
      zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse(
        autoEnable,
        memberAccountLimitReached,
        dataSources.map(value => value.asEditable)
      )
    def autoEnable: Boolean
    def memberAccountLimitReached: Boolean
    def dataSources: Optional[
      zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult.ReadOnly
    ]
    def getAutoEnable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(autoEnable)
    def getMemberAccountLimitReached: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(memberAccountLimitReached)
    def getDataSources: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult.ReadOnly
    ] = AwsError.unwrapOptionField("dataSources", dataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse
  ) extends zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.ReadOnly {
    override val autoEnable: Boolean = impl.autoEnable(): Boolean
    override val memberAccountLimitReached: Boolean =
      impl.memberAccountLimitReached(): Boolean
    override val dataSources: Optional[
      zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSources())
      .map(value =>
        zio.aws.guardduty.model.OrganizationDataSourceConfigurationsResult
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DescribeOrganizationConfigurationResponse
  ): zio.aws.guardduty.model.DescribeOrganizationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
