package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class DescribePublishingDestinationRequest(
    detectorId: DetectorId,
    destinationId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest = {
    import DescribePublishingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .destinationId(destinationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.DescribePublishingDestinationRequest.ReadOnly =
    zio.aws.guardduty.model.DescribePublishingDestinationRequest
      .wrap(buildAwsValue())
}
object DescribePublishingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.DescribePublishingDestinationRequest =
      zio.aws.guardduty.model
        .DescribePublishingDestinationRequest(detectorId, destinationId)
    def detectorId: DetectorId
    def destinationId: String
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getDestinationId: ZIO[Any, Nothing, String] = ZIO.succeed(destinationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest
  ) extends zio.aws.guardduty.model.DescribePublishingDestinationRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val destinationId: String = impl.destinationId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest
  ): zio.aws.guardduty.model.DescribePublishingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
