package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribePublishingDestinationResponse(
    destinationId: String,
    destinationType: zio.aws.guardduty.model.DestinationType,
    status: zio.aws.guardduty.model.PublishingStatus,
    publishingFailureStartTimestamp: Long,
    destinationProperties: zio.aws.guardduty.model.DestinationProperties
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse = {
    import DescribePublishingDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse
      .builder()
      .destinationId(destinationId: java.lang.String)
      .destinationType(destinationType.unwrap)
      .status(status.unwrap)
      .publishingFailureStartTimestamp(
        publishingFailureStartTimestamp: java.lang.Long
      )
      .destinationProperties(destinationProperties.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.DescribePublishingDestinationResponse.ReadOnly =
    zio.aws.guardduty.model.DescribePublishingDestinationResponse
      .wrap(buildAwsValue())
}
object DescribePublishingDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.DescribePublishingDestinationResponse =
      zio.aws.guardduty.model.DescribePublishingDestinationResponse(
        destinationId,
        destinationType,
        status,
        publishingFailureStartTimestamp,
        destinationProperties.asEditable
      )
    def destinationId: String
    def destinationType: zio.aws.guardduty.model.DestinationType
    def status: zio.aws.guardduty.model.PublishingStatus
    def publishingFailureStartTimestamp: Long
    def destinationProperties
        : zio.aws.guardduty.model.DestinationProperties.ReadOnly
    def getDestinationId: ZIO[Any, Nothing, String] = ZIO.succeed(destinationId)
    def getDestinationType
        : ZIO[Any, Nothing, zio.aws.guardduty.model.DestinationType] =
      ZIO.succeed(destinationType)
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.PublishingStatus] =
      ZIO.succeed(status)
    def getPublishingFailureStartTimestamp: ZIO[Any, Nothing, Long] =
      ZIO.succeed(publishingFailureStartTimestamp)
    def getDestinationProperties: ZIO[
      Any,
      Nothing,
      zio.aws.guardduty.model.DestinationProperties.ReadOnly
    ] = ZIO.succeed(destinationProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse
  ) extends zio.aws.guardduty.model.DescribePublishingDestinationResponse.ReadOnly {
    override val destinationId: String = impl.destinationId(): String
    override val destinationType: zio.aws.guardduty.model.DestinationType =
      zio.aws.guardduty.model.DestinationType.wrap(impl.destinationType())
    override val status: zio.aws.guardduty.model.PublishingStatus =
      zio.aws.guardduty.model.PublishingStatus.wrap(impl.status())
    override val publishingFailureStartTimestamp: Long =
      impl.publishingFailureStartTimestamp(): Long
    override val destinationProperties
        : zio.aws.guardduty.model.DestinationProperties.ReadOnly =
      zio.aws.guardduty.model.DestinationProperties
        .wrap(impl.destinationProperties())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse
  ): zio.aws.guardduty.model.DescribePublishingDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
