package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Destination(
    destinationId: String,
    destinationType: zio.aws.guardduty.model.DestinationType,
    status: zio.aws.guardduty.model.PublishingStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Destination
      .builder()
      .destinationId(destinationId: java.lang.String)
      .destinationType(destinationType.unwrap)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Destination.ReadOnly =
    zio.aws.guardduty.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Destination =
      zio.aws.guardduty.model
        .Destination(destinationId, destinationType, status)
    def destinationId: String
    def destinationType: zio.aws.guardduty.model.DestinationType
    def status: zio.aws.guardduty.model.PublishingStatus
    def getDestinationId: ZIO[Any, Nothing, String] = ZIO.succeed(destinationId)
    def getDestinationType
        : ZIO[Any, Nothing, zio.aws.guardduty.model.DestinationType] =
      ZIO.succeed(destinationType)
    def getStatus: ZIO[Any, Nothing, zio.aws.guardduty.model.PublishingStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Destination
  ) extends zio.aws.guardduty.model.Destination.ReadOnly {
    override val destinationId: String = impl.destinationId(): String
    override val destinationType: zio.aws.guardduty.model.DestinationType =
      zio.aws.guardduty.model.DestinationType.wrap(impl.destinationType())
    override val status: zio.aws.guardduty.model.PublishingStatus =
      zio.aws.guardduty.model.PublishingStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Destination
  ): zio.aws.guardduty.model.Destination.ReadOnly = new Wrapper(impl)
}
