package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DestinationProperties(
    destinationArn: Optional[String] = Optional.Absent,
    kmsKeyArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DestinationProperties = {
    import DestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DestinationProperties
      .builder()
      .optionallyWith(destinationArn.map(value => value: java.lang.String))(
        _.destinationArn
      )
      .optionallyWith(kmsKeyArn.map(value => value: java.lang.String))(
        _.kmsKeyArn
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DestinationProperties.ReadOnly =
    zio.aws.guardduty.model.DestinationProperties.wrap(buildAwsValue())
}
object DestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DestinationProperties =
      zio.aws.guardduty.model.DestinationProperties(
        destinationArn.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def destinationArn: Optional[String]
    def kmsKeyArn: Optional[String]
    def getDestinationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DestinationProperties
  ) extends zio.aws.guardduty.model.DestinationProperties.ReadOnly {
    override val destinationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationArn())
      .map(value => value: String)
    override val kmsKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DestinationProperties
  ): zio.aws.guardduty.model.DestinationProperties.ReadOnly = new Wrapper(impl)
}
