package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait DestinationType {
  def unwrap: software.amazon.awssdk.services.guardduty.model.DestinationType
}
object DestinationType {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.DestinationType
  ): zio.aws.guardduty.model.DestinationType = value match {
    case software.amazon.awssdk.services.guardduty.model.DestinationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.DestinationType.S3 =>
      val r = S3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.guardduty.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DestinationType =
      software.amazon.awssdk.services.guardduty.model.DestinationType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.guardduty.model.DestinationType {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DestinationType =
      software.amazon.awssdk.services.guardduty.model.DestinationType.S3
  }
}
