package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait DetectorStatus {
  def unwrap: software.amazon.awssdk.services.guardduty.model.DetectorStatus
}
object DetectorStatus {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.DetectorStatus
  ): zio.aws.guardduty.model.DetectorStatus = value match {
    case software.amazon.awssdk.services.guardduty.model.DetectorStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.DetectorStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.guardduty.model.DetectorStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.guardduty.model.DetectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DetectorStatus =
      software.amazon.awssdk.services.guardduty.model.DetectorStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.guardduty.model.DetectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DetectorStatus =
      software.amazon.awssdk.services.guardduty.model.DetectorStatus.ENABLED
  }
  case object DISABLED extends zio.aws.guardduty.model.DetectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.DetectorStatus =
      software.amazon.awssdk.services.guardduty.model.DetectorStatus.DISABLED
  }
}
