package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisableOrganizationAdminAccountRequest(
    adminAccountId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest = {
    import DisableOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest
      .builder()
      .adminAccountId(adminAccountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.DisableOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.guardduty.model.DisableOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object DisableOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.DisableOrganizationAdminAccountRequest =
      zio.aws.guardduty.model
        .DisableOrganizationAdminAccountRequest(adminAccountId)
    def adminAccountId: String
    def getAdminAccountId: ZIO[Any, Nothing, String] =
      ZIO.succeed(adminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest
  ) extends zio.aws.guardduty.model.DisableOrganizationAdminAccountRequest.ReadOnly {
    override val adminAccountId: String = impl.adminAccountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DisableOrganizationAdminAccountRequest
  ): zio.aws.guardduty.model.DisableOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
