package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class DisassociateFromAdministratorAccountRequest(
    detectorId: DetectorId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest = {
    import DisassociateFromAdministratorAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.DisassociateFromAdministratorAccountRequest.ReadOnly =
    zio.aws.guardduty.model.DisassociateFromAdministratorAccountRequest
      .wrap(buildAwsValue())
}
object DisassociateFromAdministratorAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.DisassociateFromAdministratorAccountRequest =
      zio.aws.guardduty.model
        .DisassociateFromAdministratorAccountRequest(detectorId)
    def detectorId: DetectorId
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest
  ) extends zio.aws.guardduty.model.DisassociateFromAdministratorAccountRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DisassociateFromAdministratorAccountRequest
  ): zio.aws.guardduty.model.DisassociateFromAdministratorAccountRequest.ReadOnly =
    new Wrapper(impl)
}
