package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateMembersResponse(
    unprocessedAccounts: Iterable[zio.aws.guardduty.model.UnprocessedAccount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse = {
    import DisassociateMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse
      .builder()
      .unprocessedAccounts(unprocessedAccounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DisassociateMembersResponse.ReadOnly =
    zio.aws.guardduty.model.DisassociateMembersResponse.wrap(buildAwsValue())
}
object DisassociateMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DisassociateMembersResponse =
      zio.aws.guardduty.model
        .DisassociateMembersResponse(unprocessedAccounts.map { item =>
          item.asEditable
        })
    def unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]
    def getUnprocessedAccounts: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.UnprocessedAccount.ReadOnly
    ]] = ZIO.succeed(unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse
  ) extends zio.aws.guardduty.model.DisassociateMembersResponse.ReadOnly {
    override val unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly] = impl
      .unprocessedAccounts()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.UnprocessedAccount.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse
  ): zio.aws.guardduty.model.DisassociateMembersResponse.ReadOnly = new Wrapper(
    impl
  )
}
