package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DnsRequestAction(
    domain: Optional[String] = Optional.Absent,
    protocol: Optional[String] = Optional.Absent,
    blocked: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DnsRequestAction = {
    import DnsRequestAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DnsRequestAction
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(blocked.map(value => value: java.lang.Boolean))(_.blocked)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DnsRequestAction.ReadOnly =
    zio.aws.guardduty.model.DnsRequestAction.wrap(buildAwsValue())
}
object DnsRequestAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DnsRequestAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DnsRequestAction =
      zio.aws.guardduty.model.DnsRequestAction(
        domain.map(value => value),
        protocol.map(value => value),
        blocked.map(value => value)
      )
    def domain: Optional[String]
    def protocol: Optional[String]
    def blocked: Optional[Boolean]
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getBlocked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blocked", blocked)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DnsRequestAction
  ) extends zio.aws.guardduty.model.DnsRequestAction.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val protocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: String)
    override val blocked: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blocked())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DnsRequestAction
  ): zio.aws.guardduty.model.DnsRequestAction.ReadOnly = new Wrapper(impl)
}
