package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainDetails(domain: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.DomainDetails = {
    import DomainDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.DomainDetails
      .builder()
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.DomainDetails.ReadOnly =
    zio.aws.guardduty.model.DomainDetails.wrap(buildAwsValue())
}
object DomainDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.DomainDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.DomainDetails =
      zio.aws.guardduty.model.DomainDetails(domain.map(value => value))
    def domain: Optional[String]
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.DomainDetails
  ) extends zio.aws.guardduty.model.DomainDetails.ReadOnly {
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.DomainDetails
  ): zio.aws.guardduty.model.DomainDetails.ReadOnly = new Wrapper(impl)
}
