package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait EbsSnapshotPreservation {
  def unwrap
      : software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation
}
object EbsSnapshotPreservation {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation
  ): zio.aws.guardduty.model.EbsSnapshotPreservation = value match {
    case software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation.NO_RETENTION =>
      val r = NO_RETENTION
      r
    case software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation.RETENTION_WITH_FINDING =>
      val r = RETENTION_WITH_FINDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.guardduty.model.EbsSnapshotPreservation {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation =
      software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_RETENTION
      extends zio.aws.guardduty.model.EbsSnapshotPreservation {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation =
      software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation.NO_RETENTION
  }
  case object RETENTION_WITH_FINDING
      extends zio.aws.guardduty.model.EbsSnapshotPreservation {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation =
      software.amazon.awssdk.services.guardduty.model.EbsSnapshotPreservation.RETENTION_WITH_FINDING
  }
}
