package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EbsVolumeDetails(
    scannedVolumeDetails: Optional[
      Iterable[zio.aws.guardduty.model.VolumeDetail]
    ] = Optional.Absent,
    skippedVolumeDetails: Optional[
      Iterable[zio.aws.guardduty.model.VolumeDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.EbsVolumeDetails = {
    import EbsVolumeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.EbsVolumeDetails
      .builder()
      .optionallyWith(
        scannedVolumeDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scannedVolumeDetails)
      .optionallyWith(
        skippedVolumeDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.skippedVolumeDetails)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.EbsVolumeDetails.ReadOnly =
    zio.aws.guardduty.model.EbsVolumeDetails.wrap(buildAwsValue())
}
object EbsVolumeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.EbsVolumeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.EbsVolumeDetails =
      zio.aws.guardduty.model.EbsVolumeDetails(
        scannedVolumeDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        skippedVolumeDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scannedVolumeDetails
        : Optional[List[zio.aws.guardduty.model.VolumeDetail.ReadOnly]]
    def skippedVolumeDetails
        : Optional[List[zio.aws.guardduty.model.VolumeDetail.ReadOnly]]
    def getScannedVolumeDetails: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.VolumeDetail.ReadOnly
    ]] =
      AwsError.unwrapOptionField("scannedVolumeDetails", scannedVolumeDetails)
    def getSkippedVolumeDetails: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.VolumeDetail.ReadOnly
    ]] =
      AwsError.unwrapOptionField("skippedVolumeDetails", skippedVolumeDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.EbsVolumeDetails
  ) extends zio.aws.guardduty.model.EbsVolumeDetails.ReadOnly {
    override val scannedVolumeDetails
        : Optional[List[zio.aws.guardduty.model.VolumeDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scannedVolumeDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.VolumeDetail.wrap(item)
          }.toList
        )
    override val skippedVolumeDetails
        : Optional[List[zio.aws.guardduty.model.VolumeDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skippedVolumeDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.VolumeDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.EbsVolumeDetails
  ): zio.aws.guardduty.model.EbsVolumeDetails.ReadOnly = new Wrapper(impl)
}
