package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EbsVolumeScanDetails(
    scanId: Optional[String] = Optional.Absent,
    scanStartedAt: Optional[Timestamp] = Optional.Absent,
    scanCompletedAt: Optional[Timestamp] = Optional.Absent,
    triggerFindingId: Optional[String] = Optional.Absent,
    sources: Optional[Iterable[String]] = Optional.Absent,
    scanDetections: Optional[zio.aws.guardduty.model.ScanDetections] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.EbsVolumeScanDetails = {
    import EbsVolumeScanDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.EbsVolumeScanDetails
      .builder()
      .optionallyWith(scanId.map(value => value: java.lang.String))(_.scanId)
      .optionallyWith(
        scanStartedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.scanStartedAt)
      .optionallyWith(
        scanCompletedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.scanCompletedAt)
      .optionallyWith(triggerFindingId.map(value => value: java.lang.String))(
        _.triggerFindingId
      )
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(scanDetections.map(value => value.buildAwsValue()))(
        _.scanDetections
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.EbsVolumeScanDetails.ReadOnly =
    zio.aws.guardduty.model.EbsVolumeScanDetails.wrap(buildAwsValue())
}
object EbsVolumeScanDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.EbsVolumeScanDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.EbsVolumeScanDetails =
      zio.aws.guardduty.model.EbsVolumeScanDetails(
        scanId.map(value => value),
        scanStartedAt.map(value => value),
        scanCompletedAt.map(value => value),
        triggerFindingId.map(value => value),
        sources.map(value => value),
        scanDetections.map(value => value.asEditable)
      )
    def scanId: Optional[String]
    def scanStartedAt: Optional[Timestamp]
    def scanCompletedAt: Optional[Timestamp]
    def triggerFindingId: Optional[String]
    def sources: Optional[List[String]]
    def scanDetections
        : Optional[zio.aws.guardduty.model.ScanDetections.ReadOnly]
    def getScanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scanId", scanId)
    def getScanStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scanStartedAt", scanStartedAt)
    def getScanCompletedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scanCompletedAt", scanCompletedAt)
    def getTriggerFindingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("triggerFindingId", triggerFindingId)
    def getSources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sources", sources)
    def getScanDetections
        : ZIO[Any, AwsError, zio.aws.guardduty.model.ScanDetections.ReadOnly] =
      AwsError.unwrapOptionField("scanDetections", scanDetections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.EbsVolumeScanDetails
  ) extends zio.aws.guardduty.model.EbsVolumeScanDetails.ReadOnly {
    override val scanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scanId())
      .map(value => value: String)
    override val scanStartedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scanStartedAt())
      .map(value => zio.aws.guardduty.model.primitives.Timestamp(value))
    override val scanCompletedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scanCompletedAt())
      .map(value => zio.aws.guardduty.model.primitives.Timestamp(value))
    override val triggerFindingId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.triggerFindingId())
      .map(value => value: String)
    override val sources: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val scanDetections
        : Optional[zio.aws.guardduty.model.ScanDetections.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanDetections())
        .map(value => zio.aws.guardduty.model.ScanDetections.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.EbsVolumeScanDetails
  ): zio.aws.guardduty.model.EbsVolumeScanDetails.ReadOnly = new Wrapper(impl)
}
