package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EbsVolumesResult(
    status: Optional[zio.aws.guardduty.model.DataSourceStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.EbsVolumesResult = {
    import EbsVolumesResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.EbsVolumesResult
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.EbsVolumesResult.ReadOnly =
    zio.aws.guardduty.model.EbsVolumesResult.wrap(buildAwsValue())
}
object EbsVolumesResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.EbsVolumesResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.EbsVolumesResult =
      zio.aws.guardduty.model.EbsVolumesResult(status.map(value => value))
    def status: Optional[zio.aws.guardduty.model.DataSourceStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.guardduty.model.DataSourceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.EbsVolumesResult
  ) extends zio.aws.guardduty.model.EbsVolumesResult.ReadOnly {
    override val status: Optional[zio.aws.guardduty.model.DataSourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.guardduty.model.DataSourceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.EbsVolumesResult
  ): zio.aws.guardduty.model.EbsVolumesResult.ReadOnly = new Wrapper(impl)
}
