package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class EcsClusterDetails(
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    activeServicesCount: Optional[Integer] = Optional.Absent,
    registeredContainerInstancesCount: Optional[Integer] = Optional.Absent,
    runningTasksCount: Optional[Integer] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.guardduty.model.Tag]] = Optional.Absent,
    taskDetails: Optional[zio.aws.guardduty.model.EcsTaskDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.EcsClusterDetails = {
    import EcsClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.EcsClusterDetails
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        activeServicesCount.map(value => value: java.lang.Integer)
      )(_.activeServicesCount)
      .optionallyWith(
        registeredContainerInstancesCount.map(value => value: java.lang.Integer)
      )(_.registeredContainerInstancesCount)
      .optionallyWith(runningTasksCount.map(value => value: java.lang.Integer))(
        _.runningTasksCount
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(taskDetails.map(value => value.buildAwsValue()))(
        _.taskDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.EcsClusterDetails.ReadOnly =
    zio.aws.guardduty.model.EcsClusterDetails.wrap(buildAwsValue())
}
object EcsClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.EcsClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.EcsClusterDetails =
      zio.aws.guardduty.model.EcsClusterDetails(
        name.map(value => value),
        arn.map(value => value),
        status.map(value => value),
        activeServicesCount.map(value => value),
        registeredContainerInstancesCount.map(value => value),
        runningTasksCount.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskDetails.map(value => value.asEditable)
      )
    def name: Optional[String]
    def arn: Optional[String]
    def status: Optional[String]
    def activeServicesCount: Optional[Integer]
    def registeredContainerInstancesCount: Optional[Integer]
    def runningTasksCount: Optional[Integer]
    def tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]]
    def taskDetails: Optional[zio.aws.guardduty.model.EcsTaskDetails.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getActiveServicesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("activeServicesCount", activeServicesCount)
    def getRegisteredContainerInstancesCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "registeredContainerInstancesCount",
        registeredContainerInstancesCount
      )
    def getRunningTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningTasksCount", runningTasksCount)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTaskDetails
        : ZIO[Any, AwsError, zio.aws.guardduty.model.EcsTaskDetails.ReadOnly] =
      AwsError.unwrapOptionField("taskDetails", taskDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.EcsClusterDetails
  ) extends zio.aws.guardduty.model.EcsClusterDetails.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val activeServicesCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.activeServicesCount())
      .map(value => value: Integer)
    override val registeredContainerInstancesCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registeredContainerInstancesCount())
        .map(value => value: Integer)
    override val runningTasksCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runningTasksCount())
      .map(value => value: Integer)
    override val tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Tag.wrap(item)
          }.toList
        )
    override val taskDetails
        : Optional[zio.aws.guardduty.model.EcsTaskDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskDetails())
        .map(value => zio.aws.guardduty.model.EcsTaskDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.EcsClusterDetails
  ): zio.aws.guardduty.model.EcsClusterDetails.ReadOnly = new Wrapper(impl)
}
