package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EcsTaskDetails(
    arn: Optional[String] = Optional.Absent,
    definitionArn: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    taskCreatedAt: Optional[Timestamp] = Optional.Absent,
    startedAt: Optional[Timestamp] = Optional.Absent,
    startedBy: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.guardduty.model.Tag]] = Optional.Absent,
    volumes: Optional[Iterable[zio.aws.guardduty.model.Volume]] =
      Optional.Absent,
    containers: Optional[Iterable[zio.aws.guardduty.model.Container]] =
      Optional.Absent,
    group: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.EcsTaskDetails = {
    import EcsTaskDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.EcsTaskDetails
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(definitionArn.map(value => value: java.lang.String))(
        _.definitionArn
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(
        taskCreatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskCreatedAt)
      .optionallyWith(startedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.EcsTaskDetails.ReadOnly =
    zio.aws.guardduty.model.EcsTaskDetails.wrap(buildAwsValue())
}
object EcsTaskDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.EcsTaskDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.EcsTaskDetails =
      zio.aws.guardduty.model.EcsTaskDetails(
        arn.map(value => value),
        definitionArn.map(value => value),
        version.map(value => value),
        taskCreatedAt.map(value => value),
        startedAt.map(value => value),
        startedBy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        group.map(value => value)
      )
    def arn: Optional[String]
    def definitionArn: Optional[String]
    def version: Optional[String]
    def taskCreatedAt: Optional[Timestamp]
    def startedAt: Optional[Timestamp]
    def startedBy: Optional[String]
    def tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]]
    def volumes: Optional[List[zio.aws.guardduty.model.Volume.ReadOnly]]
    def containers: Optional[List[zio.aws.guardduty.model.Container.ReadOnly]]
    def group: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDefinitionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("definitionArn", definitionArn)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getTaskCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskCreatedAt", taskCreatedAt)
    def getStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getContainers
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Container.ReadOnly]] =
      AwsError.unwrapOptionField("containers", containers)
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.EcsTaskDetails
  ) extends zio.aws.guardduty.model.EcsTaskDetails.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val definitionArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.definitionArn())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val taskCreatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.taskCreatedAt())
      .map(value => zio.aws.guardduty.model.primitives.Timestamp(value))
    override val startedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.guardduty.model.primitives.Timestamp(value))
    override val startedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Tag.wrap(item)
          }.toList
        )
    override val volumes
        : Optional[List[zio.aws.guardduty.model.Volume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Volume.wrap(item)
          }.toList
        )
    override val containers
        : Optional[List[zio.aws.guardduty.model.Container.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Container.wrap(item)
          }.toList
        )
    override val group: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.EcsTaskDetails
  ): zio.aws.guardduty.model.EcsTaskDetails.ReadOnly = new Wrapper(impl)
}
