package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EksClusterDetails(
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.guardduty.model.Tag]] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.EksClusterDetails = {
    import EksClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.EksClusterDetails
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.EksClusterDetails.ReadOnly =
    zio.aws.guardduty.model.EksClusterDetails.wrap(buildAwsValue())
}
object EksClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.EksClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.EksClusterDetails =
      zio.aws.guardduty.model.EksClusterDetails(
        name.map(value => value),
        arn.map(value => value),
        vpcId.map(value => value),
        status.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value)
      )
    def name: Optional[String]
    def arn: Optional[String]
    def vpcId: Optional[String]
    def status: Optional[String]
    def tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]]
    def createdAt: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.EksClusterDetails
  ) extends zio.aws.guardduty.model.EksClusterDetails.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.guardduty.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.Tag.wrap(item)
          }.toList
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.guardduty.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.EksClusterDetails
  ): zio.aws.guardduty.model.EksClusterDetails.ReadOnly = new Wrapper(impl)
}
