package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EnableOrganizationAdminAccountRequest(adminAccountId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest = {
    import EnableOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest
      .builder()
      .adminAccountId(adminAccountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.guardduty.model.EnableOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object EnableOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.EnableOrganizationAdminAccountRequest =
      zio.aws.guardduty.model
        .EnableOrganizationAdminAccountRequest(adminAccountId)
    def adminAccountId: String
    def getAdminAccountId: ZIO[Any, Nothing, String] =
      ZIO.succeed(adminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest
  ) extends zio.aws.guardduty.model.EnableOrganizationAdminAccountRequest.ReadOnly {
    override val adminAccountId: String = impl.adminAccountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.EnableOrganizationAdminAccountRequest
  ): zio.aws.guardduty.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
