package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Evidence(
    threatIntelligenceDetails: Optional[
      Iterable[zio.aws.guardduty.model.ThreatIntelligenceDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Evidence = {
    import Evidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Evidence
      .builder()
      .optionallyWith(
        threatIntelligenceDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelligenceDetails)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Evidence.ReadOnly =
    zio.aws.guardduty.model.Evidence.wrap(buildAwsValue())
}
object Evidence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.Evidence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Evidence =
      zio.aws.guardduty.model.Evidence(
        threatIntelligenceDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def threatIntelligenceDetails: Optional[
      List[zio.aws.guardduty.model.ThreatIntelligenceDetail.ReadOnly]
    ]
    def getThreatIntelligenceDetails: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.ThreatIntelligenceDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelligenceDetails",
      threatIntelligenceDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Evidence
  ) extends zio.aws.guardduty.model.Evidence.ReadOnly {
    override val threatIntelligenceDetails: Optional[
      List[zio.aws.guardduty.model.ThreatIntelligenceDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.threatIntelligenceDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.guardduty.model.ThreatIntelligenceDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Evidence
  ): zio.aws.guardduty.model.Evidence.ReadOnly = new Wrapper(impl)
}
