package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait Feedback {
  def unwrap: software.amazon.awssdk.services.guardduty.model.Feedback
}
object Feedback {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.Feedback
  ): zio.aws.guardduty.model.Feedback = value match {
    case software.amazon.awssdk.services.guardduty.model.Feedback.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.Feedback.USEFUL =>
      val r = USEFUL
      r
    case software.amazon.awssdk.services.guardduty.model.Feedback.NOT_USEFUL =>
      val r = NOT_USEFUL
      r
  }
  case object unknownToSdkVersion extends zio.aws.guardduty.model.Feedback {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.Feedback =
      software.amazon.awssdk.services.guardduty.model.Feedback.UNKNOWN_TO_SDK_VERSION
  }
  case object USEFUL extends zio.aws.guardduty.model.Feedback {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.Feedback =
      software.amazon.awssdk.services.guardduty.model.Feedback.USEFUL
  }
  case object NOT_USEFUL extends zio.aws.guardduty.model.Feedback {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.Feedback =
      software.amazon.awssdk.services.guardduty.model.Feedback.NOT_USEFUL
  }
}
